<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Send FCM Notification - Roger</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background: #ffcc00;
      margin: 0;
      padding: 0;
      color: #111;
    }

    .header {
      background-color: #000;
      padding: 16px 30px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      color: white;
    }

    .logo img {
      height: 40px;
    }

    .logout a {
      color: #fff;
      text-decoration: none;
      font-weight: bold;
      font-size: 14px;
      padding: 8px 14px;
      background: transparent;
      border: 1px solid #fff;
      border-radius: 6px;
      transition: all 0.3s;
    }

    .logout a:hover {
      background: #fff;
      color: #000;
    }

    .form-container {
      background: #fff;
      padding: 35px;
      max-width: 520px;
      margin: 60px auto;
      border-radius: 16px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    }

    h2 {
      text-align: center;
      color: #000;
      margin-bottom: 30px;
      font-weight: 600;
    }

    label {
      display: block;
      margin-bottom: 8px;
      color: #222;
      font-weight: 500;
    }

    input[type="text"],
    textarea {
      width: 100%;
      padding: 12px 14px;
      margin-bottom: 20px;
      border: 1px solid #ccc;
      border-radius: 8px;
      font-size: 14px;
      box-sizing: border-box; 
      box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.08);
    }

    textarea {
      resize: vertical;
      height: 110px;
    }

    input[type="file"] {
      display: block;
      width: 100%;
      padding: 10px 14px;
      background-color: #fff;
      border: 1px solid #ccc;
      border-radius: 8px;
      font-size: 14px;
      color: #333;
      cursor: pointer;
      box-sizing: border-box;
    }

    input[type="file"]::-webkit-file-upload-button {
      background-color: #000;
      color: #fff;
      border: none;
      padding: 10px 16px;
      border-radius: 6px;
      cursor: pointer;
      font-weight: 600;
      transition: background-color 0.3s ease;
    }

    input[type="file"]::-webkit-file-upload-button:hover {
      background-color: #333;
    }

    .note {
      font-size: 12px;
      color: #666;
      margin-top: -10px;
      margin-bottom: 20px;
    }

    button {
      background-color: #000;
      color: #fff;
      padding: 14px 20px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      width: 100%;
      font-size: 16px;
      font-weight: bold;
      transition: background 0.3s ease;
    }

    button:hover {
      background-color: #333;
    }

    /* Success and Error message styles */
    .message {
      max-width: 520px;
      margin: 20px auto;
      padding: 15px 20px;
      border-radius: 12px;
      font-weight: 600;
      text-align: center;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    .message.success {
      background-color: #d4edda;
      color: #155724;
      border: 1px solid #c3e6cb;
    }

    .message.error {
      background-color: #f8d7da;
      color: #721c24;
      border: 1px solid #f5c6cb;
    }
  </style>
</head>
<body>

  <div class="header">
    <div class="logo">
      <img src="logo.jpg" alt="Roger Logo" />
    </div>
    <div class="logout">
      <a href="logout.php">Logout</a>
    </div>
  </div>

  <?php
  if (isset($_GET['status'])) {
      if ($_GET['status'] === 'success') {
          echo "<div class='message success'>Notification sent successfully!</div>";
      } elseif ($_GET['status'] === 'error') {
          $message = htmlspecialchars(urldecode($_GET['message']), ENT_QUOTES, 'UTF-8');
          echo "<div class='message error'>Error: {$message}</div>";
      }
  }
  ?>

  <div class="form-container">
    <h2>Send FCM Notification</h2>
    <form action="send_notification.php" method="post" enctype="multipart/form-data">
      <label for="title">Title</label>
      <input type="text" id="title" name="title" required />

      <label for="body">Body</label>
      <textarea id="body" name="body" required></textarea>

      <label for="image">Image</label>
      <input type="file" id="image" name="image" accept="image/*" /> 
      <br />
      <div class="note">Optional. Upload an image to include in the notification.</div>

      <button type="submit">Send Notification</button>
    </form>
  </div>

</body>
</html>
