<?php

function base64UrlEncode($data) {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function getAccessToken($serviceAccountPath) {
    $now = time();
    $serviceAccount = json_decode(file_get_contents($serviceAccountPath), true);

    $header = ['alg' => 'RS256', 'typ' => 'JWT'];
    $payload = [
        'iss' => $serviceAccount['client_email'],
        'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
        'aud' => 'https://oauth2.googleapis.com/token',
        'iat' => $now,
        'exp' => $now + 3600,
    ];

    $jwtHeader = base64UrlEncode(json_encode($header));
    $jwtPayload = base64UrlEncode(json_encode($payload));
    $data = "$jwtHeader.$jwtPayload";

    openssl_sign($data, $signature, $serviceAccount['private_key'], 'sha256');
    $jwt = $data . '.' . base64UrlEncode($signature);

    $ch = curl_init('https://oauth2.googleapis.com/token');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt,
    ]));
    curl_setopt($ch, CURLOPT_POST, true);

    $response = json_decode(curl_exec($ch), true);
    curl_close($ch);

    if (isset($response['access_token'])) {
        return $response['access_token'];
    }

    throw new Exception('Access token fetch failed: ' . json_encode($response));
}

function sendNotification($title, $body, $image = '', $topic = 'general_topic') {
    $serviceAccountPath = __DIR__ . '/firebase-service-account.json';
    $accessToken = getAccessToken($serviceAccountPath);

    $projectId = json_decode(file_get_contents($serviceAccountPath), true)['project_id'];
    $url = "https://fcm.googleapis.com/v1/projects/$projectId/messages:send";

    $notificationPayload = [
        'title' => $title,
        'body'  => $body,
    ];

    if (!empty($image)) {
        $notificationPayload['image'] = $image;
    }

    $message = [
        'message' => [
            'topic' => $topic,
            'notification' => $notificationPayload,
            'data' => [
                'custom_key' => 'custom_value' // Optional extra data
            ],
        ],
    ];
// print_r($message); die;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json',
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($message));
    curl_setopt($ch, CURLOPT_POST, true);

    $result = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    return [
        'code' => $httpCode,
        'response' => json_decode($result, true),
    ];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'] ?? '';
    $body  = $_POST['body'] ?? '';
    $topic = 'general_topic';
    $image = '';

    if (!empty($_FILES['image']['tmp_name']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = __DIR__ . '/uploads/';
        $uploadFileName = basename($_FILES['image']['name']);
        $uploadPath = $uploadDir . $uploadFileName;

        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }

        if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadPath)) {
            // Optional: Convert to a public URL
            $image = 'https://tester.hanaplatform.com/notification/uploads/' . $uploadFileName;
            // echo $image;die;
        }
    }

    try {
        $result = sendNotification($title, $body, $image, $topic);
        
        // Optionally store result in session if needed
        // session_start();
        // $_SESSION['notification_result'] = $result;
    
        // Redirect to index page after success
        header('Location: index.php?status=success');
        exit;
    } catch (Exception $e) {
        // Redirect with error message (encoded to be URL safe)
        $errorMessage = urlencode($e->getMessage());
        header("Location: index.php?status=error&message={$errorMessage}");
        exit;
    }
} else {
    echo "<p>Invalid request method</p>";
}
